<?php
function theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'avada-stylesheet' ), filemtime(get_stylesheet_directory() . '/style.css') );
    wp_enqueue_style( 'vim', get_stylesheet_directory_uri() . 'style.css' );
    wp_enqueue_script( 'vim-js', get_stylesheet_directory_uri() . '/assets/js/scripts.js', array( 'jquery'), filemtime(get_stylesheet_directory() . '/assets/js/scripts.js'), true );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles' );

function avada_lang_setup() {
	$lang = get_stylesheet_directory() . '/languages';
	load_child_theme_textdomain( 'Avada', $lang );
}
add_action( 'after_setup_theme', 'avada_lang_setup' );

function delete_post_type(){
	unregister_post_type( 'avada_faq' );
	unregister_post_type( 'avada_portfolio' );
}
add_action('init','delete_post_type',100);


// Change 'add to cart' text on single product page
add_filter( 'woocommerce_product_single_add_to_cart_text', 'carillo_add_to_cart_text' );
function carillo_add_to_cart_text() {
        return __( 'contactar un asesor', 'your-slug' );
}

 
add_filter( 'woocommerce_variable_sale_price_html', 'carrillo_remove_prices', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'carrillo_remove_prices', 10, 2 );
add_filter( 'woocommerce_get_price_html', 'carrillo_remove_prices', 10, 2 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
function carrillo_remove_prices( $price, $product ) {
$price = '';
return $price;
}
add_filter('woocommerce_product_description_heading', '__return_null');
/** @Hide quantity using CSS */
function hide_quantity_using_css() {
    if ( is_product() ) {
 ?>
    <style type="text/css">.quantity, .buttons_added { width:0; height:0; display: none; visibility: hidden; }</style>
    <?php
    }
}
add_action( 'wp_head', 'hide_quantity_using_css' );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
add_action( 'woocommerce_single_product_summary', 'the_content', 20 );
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs ) {
    unset( $tabs['description'] );      	// Remove the description tab
    unset( $tabs['additional_information'] );  	// Remove the additional information tab
    return $tabs;

}
/**
 * Remove related products output
 */
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart');