/**
 * Contain the logic for modal backdrops.
 *
 * @module     core/modal_backdrop
 * @class      modal_backdrop
 * @package    core
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/modal_backdrop",["jquery","core/templates","core/notification","core/fullscreen"],(function($,Templates,Notification,Fullscreen){var SELECTORS_ROOT='[data-region="modal-backdrop"]',ModalBackdrop=function(root){this.root=$(root),this.isAttached=!1,this.attachmentPoint=document.createElement("div"),document.body.append(this.attachmentPoint),this.root.is(SELECTORS_ROOT)||Notification.exception({message:"Element is not a modal backdrop"})};return ModalBackdrop.prototype.getRoot=function(){return this.root},ModalBackdrop.prototype.getAttachmentPoint=function(){return $(Fullscreen.getElement()||this.attachmentPoint)},ModalBackdrop.prototype.attachToDOM=function(){this.getAttachmentPoint().append(this.root),this.isAttached||(this.isAttached=!0)},ModalBackdrop.prototype.setZIndex=function(value){this.root.css("z-index",value)},ModalBackdrop.prototype.isVisible=function(){return this.root.hasClass("show")},ModalBackdrop.prototype.hasTransitions=function(){return this.getRoot().hasClass("fade")},ModalBackdrop.prototype.show=function(){this.isVisible()||(this.attachToDOM(),this.root.removeClass("hide").addClass("show"))},ModalBackdrop.prototype.hide=function(){this.isVisible()&&(this.hasTransitions()?this.getRoot().one("transitionend webkitTransitionEnd oTransitionEnd",function(){this.getRoot().removeClass("show").addClass("hide")}.bind(this)):this.getRoot().removeClass("show").addClass("hide"),$(document.body).find(this.getRoot()).length&&$(document.body).append(this.getRoot()))},ModalBackdrop.prototype.destroy=function(){this.root.remove(),this.attachmentPoint.remove()},ModalBackdrop}));

//# sourceMappingURL=modal_backdrop.min.js.map