/**
 * Controls the message preference page.
 *
 * @module     core_message/message_preferences
 * @class      message_preferences
 * @package    message
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_preferences",["jquery","core/ajax","core/notification","core_message/message_notification_preference","core/custom_interaction_events"],(function($,Ajax,Notification,MessageNotificationPreference,CustomEvents){var SELECTORS_PREFERENCE="[data-state]",SELECTORS_PREFERENCES_CONTAINER='[data-region="preferences-container"]',SELECTORS_CONTACTABLE_PRIVACY_CONTAINER='[data-region="privacy-setting-container"]',MessagePreferences=function(element){this.root=$(element),this.userId=this.root.find(SELECTORS_PREFERENCES_CONTAINER).attr("data-user-id"),this.registerEventListeners()};return MessagePreferences.prototype.preferencesDisabled=function(){return this.root.find(SELECTORS_PREFERENCES_CONTAINER).hasClass("disabled")},MessagePreferences.prototype.saveContactablePrivacySetting=function(){var container=this.root.find(SELECTORS_CONTACTABLE_PRIVACY_CONTAINER),value=$("input[type='radio']:checked").val();if(container.hasClass("loading"))return $.Deferred().resolve();container.addClass("loading");var request={methodname:"core_user_update_user_preferences",args:{userid:this.userId,preferences:[{type:container.attr("data-preference-key"),value:value}]}};return Ajax.call([request])[0].fail(Notification.exception).always((function(){container.removeClass("loading")}))},MessagePreferences.prototype.registerEventListeners=function(){CustomEvents.define(this.root,[CustomEvents.events.activate]),this.root.on("change",function(e){if("message_blocknoncontacts"==e.target.name)this.saveContactablePrivacySetting();else if(!this.preferencesDisabled()){var preferencesContainer=$(e.target).closest(SELECTORS_PREFERENCES_CONTAINER),preferenceElement=$(e.target).closest(SELECTORS_PREFERENCE),messagePreference=new MessageNotificationPreference(preferencesContainer,this.userId);preferenceElement.addClass("loading"),messagePreference.save().always((function(){preferenceElement.removeClass("loading")}))}}.bind(this))},MessagePreferences}));

//# sourceMappingURL=message_preferences.min.js.map